#include <windows.h>

#include "AVIreader.h"

AVIreader::AVIreader()
{
	AVIFileInit(); //!!! Init AVI-Dll

	last_frame = 0;

	avi_frame_counter = 0;
}

AVIreader::~AVIreader()
{
	Close();

	AVIFileExit(); //!!! close AVI-Dll stuff
}

AVIreader::AVIreader(char * const filename)
{
	AVIFileInit(); //!!! Init AVI-Dll

	last_frame = 0;

	avi_frame_counter = 0;

	Open(filename);
}

bool AVIreader::Open(char * const filename)
{
	Close(); //4 Safety

	if(AVIStreamOpenFromFile(&pavi, filename, streamtypeVIDEO, 0, OF_READ, NULL) !=0)
	{		
		MessageBox(NULL,"AVIStreamOpenFromFile","UhOh!",MB_OK|MB_ICONSTOP);
		return false;
	}

	AVIStreamInfo(pavi, &psi, sizeof(psi));				// Reads Information About The Stream Into psi
	xres = psi.rcFrame.right-psi.rcFrame.left;			// Width Is Right Side Of Frame Minus Left
	yres = psi.rcFrame.bottom-psi.rcFrame.top;			// Height Is Bottom Of Frame Minus Top

	last_frame = AVIStreamLength(pavi);					// The Last Frame Of The Stream
	avi_frame_counter = 1;

	//mpf=AVIStreamSampleToTime(pavi,lastframe)/lastframe;	// Calculate Rough Milliseconds Per Frame

	pgf = AVIStreamGetFrameOpen(pavi, NULL);			// Create The PGETFRAME Using Our Request Mode
	if (pgf == NULL)
	{
		MessageBox(NULL,"AVIStreamGetFrameOpen","UhOh!",MB_OK|MB_ICONSTOP);
		return false;
	}

	return true;
}

bool AVIreader::Get(unsigned int * const pic, const unsigned int frame)
{	
	LPBITMAPINFOHEADER lpbi = (LPBITMAPINFOHEADER)AVIStreamGetFrame(pgf, frame);			// Holds The Bitmap Header Information & Grab Data From The AVI Stream
	if(lpbi == NULL)
	{
		MessageBox(NULL,"AVIStreamGetFrame","UhOh!",MB_OK|MB_ICONSTOP);
		return false;
	}

	avi_frame_counter = frame+1;

	//memcpy(pic,(char *)lpbi + lpbi->biSize + lpbi->biClrUsed*sizeof(RGBQUAD),xres*yres*3);	//!!! Pointer To Data Returned By AVIStreamGetFrame (Skip The Header Info To Get To The Data)

	unsigned char * const tmp_pic = (unsigned char *)lpbi + lpbi->biSize + lpbi->biClrUsed*sizeof(RGBQUAD);
	for(unsigned int o = 0; o < xres*yres; o++)
		pic[o] = ((unsigned int)tmp_pic[o*3]) | (((unsigned int)(tmp_pic[o*3+1]))<<8) | (((unsigned int)(tmp_pic[o*3+2]))<<16);

	return true;
}

bool AVIreader::Get(unsigned int * const pic)
{	
	return Get(pic, avi_frame_counter);
}

void AVIreader::Close()
{
	if(last_frame > 0)
	{
		AVIStreamGetFrameClose(pgf);						// Deallocates The GetFrame Resources
		AVIStreamRelease(pavi);								// Release The Stream	

		last_frame = 0;

		avi_frame_counter = 0;
	}
}
