#include <windows.h>

class GIFframe {
public:
	unsigned int xres, yres;
	unsigned int BPP;
	unsigned char * pic;
	COLORREF * pal;
	unsigned int Transparent;			// ~0u for none

	// animations
	unsigned int xPos, yPos;			// Relative Position
	unsigned int Delay;					// Delay after image in 1/1000 seconds
	unsigned int Transparency;

	GIFframe()  { pic = 0; pal = 0; }
	~GIFframe() { if(pic) delete [] pic; if(pal) delete [] pal; }

	void Init(const unsigned int _xres, const unsigned int _yres, const unsigned int _BPP);

	inline unsigned char Get(const unsigned int x, const unsigned int y) const
	{ return pic[y*xres+x]; }
};

class GIFreader {
public:
	unsigned int xres, yres;

	GIFframe ** img;
	unsigned int last_frame;
	unsigned int gif_frame_counter;

	void AddFrame(GIFframe* const newframe);

	GIFreader()  { img = 0; last_frame = 0; gif_frame_counter = 0; }
	~GIFreader() { if(img) { for (unsigned int n = 0; n < last_frame; n++) delete img[n]; delete [] img; }}

	int Open(const char* const szFile);

	bool Get(unsigned int * const pic, const unsigned int frame);
	bool Get(unsigned int * const pic);
};
